    <%@ Page Language="C#" MasterPageFile="~/MasterPage.master" AutoEventWireup="true" Theme="Voxco"
    EnableSessionState="True" Trace="false" Async="true" Inherits="Voxco.Reporting.ReportSettingstDateTimes"
    Title="<%$ Resources:Resource, VoxcoReporting%>" EnableEventValidation="false" Codebehind="ReportSettingstDateTimes.aspx.cs" %>

<%@ Register Src="~/WaitingPanel.ascx" TagPrefix="VxRpt" TagName="WaitingPanel" %>
<%@ Register Src="../Common/ToggleHeader.ascx" TagName="ToggleHeader" TagPrefix="uc1" %>

<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>

<asp:Content ID="Content1" ContentPlaceHolderID="MainContent" runat="Server">
	
	<telerik:RadScriptBlock ID="RadSCriptBlock1" runat="server">
		<script type="text/javascript" >
			function UpdateDateTimeFilter()
			{				
				$find("<%= RadAjaxPanel2.ClientID %>").ajaxRequest("UpdateDateTimeFilter");
			}
			function onFromDateChanged(sender, e)
            {
                 var _toChooser = $find("<%= RadEndFilterDatepicker.ClientID %>"); 
                 var _toDate =  _toChooser.get_selectedDate();
                 var _fromChooser = $find("<%= RadStartFilterDatepicker.ClientID %>");
                 var _fromDate= _fromChooser.get_selectedDate();
                 if (_toDate != undefined && _fromDate != undefined)
	                {
		                var _d1 = Date.parse(_fromDate);
		                var _d2 = Date.parse(_toDate);
		                if (_d1 > _d2)
		                {
		                    sender.clear();
                            alert("<%= GetFilterDateErrorMessage() %>");
			                return(false);
		                }
	                }
          }
		
		</script>
	</telerik:RadScriptBlock>
    
    <asp:ObjectDataSource ID="SelectedDateDataSource" runat="server" SelectMethod="GetGenericDate" TypeName="Voxco.Reporting.DataSource.SelectedDates">
    </asp:ObjectDataSource>
    <asp:ObjectDataSource ID="SelectedTimeSliceDataSource" runat="server" SelectMethod="GetGenericTimeSlice" TypeName="Voxco.Reporting.DataSource.SelectedTimeSlices">
    </asp:ObjectDataSource>
    
    <telerik:RadAjaxPanel ID="RadAjaxPanel2" runat="server" EnableAJAX="true" Width="100%" LoadingPanelID="MainAjaxLoadingPanel">
        
        <telerik:RadAjaxLoadingPanel ID="MainAjaxLoadingPanel" runat="server">
            <VxRpt:WaitingPanel id="WaitingPanel" runat="server" />
        </telerik:RadAjaxLoadingPanel>
        <br />
        
        <asp:Panel ID="RadSplitter1" runat="server" Height="500px" Width="100%" ScrollBars="Auto">
        
			<div id="RadPaneLeft" runat="server"  style="float: left; width: 45%; margin-right:25px; height: 100%;">				
				
				<asp:Label ID="TitleDate" runat="server" Text="<%$ Resources:Resource, Dates%>" CssClass="title" />
				<br />
				<div class="frame">
					<asp:Label ID="Label3" runat="server" Text="<%$ Resources:Resource, FilteredDates%>" CssClass="title" />
					<br />	
					<asp:RadioButtonList ID="radioFilterOption" runat="server" AutoPostBack="True" RepeatDirection="Horizontal" OnSelectedIndexChanged="radioFilterOption_OnSelectedIndexChanged">
						<asp:ListItem Selected="True" Text="<%$ Resources:Resource, Dates %>" Value="Dates"></asp:ListItem>
						<asp:ListItem Text="<%$ Resources:Resource, CurrentDay %>" Value="Current Day"></asp:ListItem>
						<asp:ListItem Text="<%$ Resources:Resource, CurrentWeek %>" Value="Current Week"></asp:ListItem>
						<asp:ListItem Text="<%$ Resources:Resource, CurrentMonth %>" Value="Current Month"></asp:ListItem>
						<asp:ListItem Text="<%$ Resources:Resource, All %>" Value="All"></asp:ListItem>
					</asp:RadioButtonList>

					<asp:Label ID="Label1" runat="server" Font-Size="Small" Text="<%$ Resources:Resource, From%>"></asp:Label>
					<telerik:RadDatePicker ID="RadStartFilterDatepicker"  runat="server">
						<DatePopupButton ToolTip="<%$ Resources:Resource, OpenCalendar%>" />
						<DateInput ID="StartDateInput" runat="server"></DateInput>
						<Calendar runat ="server">
							<SpecialDays> 
								<telerik:RadCalendarDay repeatable="Today" date="">
									<ItemStyle CssClass="radCalToday_Default">
									</ItemStyle> 
								</telerik:RadCalendarDay>
							</SpecialDays>
							<FastNavigationSettings  CancelButtonCaption="<%$ Resources:Resource, Cancel%>" OkButtonCaption="<%$ Resources:Resource, Ok%>" TodayButtonCaption="<%$ Resources:Resource, CurrentMonth%>" />
						</Calendar>
					</telerik:RadDatePicker>
						
					<asp:Label ID="Label2" runat="server" Font-Size="Small" Text="<%$ Resources:Resource, To%>"></asp:Label>
					<telerik:RadDatePicker ID="RadEndFilterDatepicker" runat="server">
						<DatePopupButton ToolTip="<%$ Resources:Resource, OpenCalendar%>" />
						<DateInput ID="EndDateInput" runat="server"></DateInput>
						<Calendar runat="server">
							<SpecialDays> 
								<telerik:RadCalendarDay repeatable="Today" date="">
									<ItemStyle CssClass="radCalToday_Default">
									</ItemStyle> 
								</telerik:RadCalendarDay>
							</SpecialDays>
							<FastNavigationSettings  CancelButtonCaption="<%$ Resources:Resource, Cancel%>" OkButtonCaption="<%$ Resources:Resource, Ok%>" TodayButtonCaption="<%$ Resources:Resource, CurrentMonth%>" />
						</Calendar>
					</telerik:RadDatePicker>
				</div>
				
				<div id="SelectedDates" runat="server" class="frame">
					<asp:Label ID="TitleSelectedDates" runat="server" Text="<%$ Resources:Resource, SelectedDates%>" CssClass="title" />
					<telerik:RadGrid ID="grdDates" runat="server" GridLines="None" AllowMultiRowSelection="True" Height="380px"
					AutoGenerateColumns="False" DataSourceID="SelectedDateDataSource" 
					EnableEmbeddedBaseStylesheet="false" EnableEmbeddedSkins="false" Skin="Voxco" ClientSettings-EnableRowHoverStyle="true">
						<ClientSettings>
							<Selecting AllowRowSelect="True" />
							<Scrolling AllowScroll="true" UseStaticHeaders="true" />
						</ClientSettings>
						<MasterTableView DataSourceID="SelectedDateDataSource" NoMasterRecordsText="" CommandItemDisplay="Top" ShowHeadersWhenNoRecords="true" Width="100%">
							<CommandItemTemplate>
								<telerik:RadCalendar ID="RadCalendar1" runat="server" EnableMultiSelect="true">
									<FastNavigationSettings  CancelButtonCaption="<%$ Resources:Resource, Cancel%>" OkButtonCaption="<%$ Resources:Resource, Ok%>" TodayButtonCaption="<%$ Resources:Resource, CurrentMonth%>" />
									<SpecialDays>
										<telerik:RadCalendarDay Repeatable="Today" Date="">
											<ItemStyle CssClass="radCalToday_Default"></ItemStyle>
										</telerik:RadCalendarDay>
									</SpecialDays>
								</telerik:RadCalendar>
								
								<asp:LinkButton ID="InsertDateButton" CommandName="Insert" CausesValidation="false" Visible="true" ToolTip="<%$ Resources:Resource, Add %>" runat="server" OnClick="InsertDateButton_Click">
									<img style="border: 0px;" alt="" src="../icons/element_new.png" />
									<asp:Label ID="Label9" runat="server" Text="<%$ Resources:Resource, Add %>"></asp:Label>
								</asp:LinkButton>
								
								<asp:LinkButton ID="DeleteDateButton" CommandName="Delete" CausesValidation="false" Visible="true" ToolTip="<%$ Resources:Resource, Delete %>" runat="server" OnClick="DeleteDateButton_Click">
									<img style="border: 0px;" alt="" src="../icons/trash.gif" />
									<asp:Label ID="Label5" runat="server" Text="<%$ Resources:Resource, Delete %>"></asp:Label>
								</asp:LinkButton>
											
								<asp:LinkButton ID="ClearButton" CommandName="Cancel" CausesValidation="false" Visible="true" ToolTip="<%$ Resources:Resource, Clear %>" runat="server" OnClick="ClearDateButton_Click">
									<img style="border: 0px;" alt="" src="../icons/cancel.gif" />
									<asp:Label ID="lbClear" runat="server" Text="<%$ Resources:Resource, Clear %>"></asp:Label>
								</asp:LinkButton>
			
								<asp:LinkButton ID="MoveUpButton" CommandName="MoveUp" CausesValidation="false" Visible="true" ToolTip="<%$ Resources:Resource, MoveUp %>" runat="server" OnClick="MoveUpDateButton_Click">
									<img style="border: 0px;" alt="" src="../icons/arrow_up_blue.png" />
									<asp:Label ID="Label11" runat="server" Text="<%$ Resources:Resource, MoveUp %>"></asp:Label>
								</asp:LinkButton>
								
								<asp:LinkButton ID="MoveDownButton" CommandName="MoveDown" CausesValidation="false" Visible="true" ToolTip="<%$ Resources:Resource, MoveDown %>" runat="server" OnClick="MoveDownDateButton_Click">
									<img style="border: 0px;" alt="" src="../icons/arrow_down_blue.png" />
									<asp:Label ID="Label12" runat="server" Text="<%$ Resources:Resource, MoveDown %>"></asp:Label>
								</asp:LinkButton>
       
							</CommandItemTemplate>
							<Columns>
								<telerik:GridClientSelectColumn DataType="System.Boolean" UniqueName="Selected">
									<HeaderStyle HorizontalAlign="Left" Width="10%" />
									<ItemStyle HorizontalAlign="Left" Width="10%"/>
								</telerik:GridClientSelectColumn>
								<telerik:GridBoundColumn DataField="Date" DataType="System.String" HeaderText="<%$ Resources:Resource, SelectedDates %>" UniqueName="Date">
									<HeaderStyle Width="90%" HorizontalAlign="left" />
									<ItemStyle Width="90%" HorizontalAlign="Left" />
								</telerik:GridBoundColumn>
							</Columns>
						</MasterTableView>
					</telerik:RadGrid>					
				</div>			
            
			</div>	
			
			<div id="RadPaneRight" runat="server" style="float: left; width: 45%;">				
				
				<asp:Label ID="TitleTimeRange" runat ="server" Text="<%$ Resources:Resource, TimeRanges%>" CssClass="title" />
				
				<div class="frame">
					<asp:Label ID="Label7" runat="server" Text="<%$ Resources:Resource, FilteredTimeRanges%>" CssClass="title" />                
					<br />
					<asp:Label ID="Label8" runat="server" Font-Size="Small" Text="<%$ Resources:Resource, From%>"></asp:Label>
					<telerik:RadTimePicker ID="RadStartFilterTimePicker" runat="server" Culture="fr-CA"
						TimeView-HeaderText="<%$ Resources:Resource, TimePicker%>">
						<TimePopupButton ToolTip="<%$ Resources:Resource, OpenTimePopUp%>"/>
						<TimeView runat="server" Columns="5" TimeFormat="HH:mm">
						</TimeView>
						<DateInput runat="server" Width="50px" DateFormat="HH:mm" >
						</DateInput>
					</telerik:RadTimePicker>

					<asp:Label ID="Label10" runat="server" Font-Size="Small" Text="<%$ Resources:Resource, To%>"></asp:Label>
					<telerik:RadTimePicker ID="RadEndFilterTimePicker" runat="server" Culture="fr-CA" 
						TimeView-HeaderText="<%$ Resources:Resource, TimePicker%>">
						<TimePopupButton ToolTip="<%$ Resources:Resource, OpenTimePopUp%>" />
						<TimeView runat="server" Columns="5" TimeFormat="HH:mm">
						</TimeView>
						<DateInput runat="server" Width="50px" DateFormat="HH:mm" >
						</DateInput>
					</telerik:RadTimePicker>
				</div>
                                  
				<div id="SelectedTimeSlice" runat="server" class="frame">				
					<asp:Label ID="TitleSelectedTimeRanges" runat="server" Text="<%$ Resources:Resource, SelectedTimeRanges%>" />
					<br />
					<asp:Label ID="lbFrom" runat="server" Font-Size="Small" Text="<%$ Resources:Resource, From%>"></asp:Label>
					<telerik:RadTimePicker ID="RadStartTimePicker" runat="server" Culture="fr-CA" 
						TimeView-HeaderText="<%$ Resources:Resource, TimePicker%>">
						<TimePopupButton ToolTip="<%$ Resources:Resource, OpenTimePopUp%>" />
						<TimeView runat="server" Interval="1:0:0" Columns="5" TimeFormat="HH:mm">
						</TimeView>
						<DateInput runat="server" Width="50px" DateFormat="HH:mm">
						</DateInput>
					</telerik:RadTimePicker>								

					<asp:Label ID="lbTo" runat="server" Font-Size="Small" Text="<%$ Resources:Resource, To%>"></asp:Label>
					<telerik:RadTimePicker ID="RadEndTimePicker" runat="server" Culture="fr-CA" 
						TimeView-HeaderText="<%$ Resources:Resource, TimePicker%>">
						<TimePopupButton ToolTip="<%$ Resources:Resource, OpenTimePopUp%>" />
						<TimeView runat="server" Interval="1:0:0" Columns="5" TimeFormat="HH:mm">
						</TimeView>
						<DateInput runat="server" Width="50px" DateFormat="HH:mm">
						</DateInput>
					</telerik:RadTimePicker>

					<asp:RadioButtonList ID="RadioButtonList1" runat="server">
						<asp:ListItem Value="true" Selected="True" Text="<%$ Resources:Resource, BreakdownBy%>"></asp:ListItem>
						<asp:ListItem Value="false" Text="<%$ Resources:Resource, NoBreakdown%>">Block</asp:ListItem>
					</asp:RadioButtonList>
	 
					<telerik:RadTextBox ID="TxtInterval" Width="40px" runat="server" Text="60">
					</telerik:RadTextBox>
					
					<asp:Label ID="Label13" runat="server" Font-Size="Small" Text="<%$ Resources:Resource, MinuteUnit%>"></asp:Label>
				
				</div>
				
				<div id="GrdDisplayTimeSlice" runat="server" class="frame">
					<telerik:RadGrid ID="grdTimeSlice" runat="server" AllowMultiRowSelection="True" Height="300px" AutoGenerateColumns="False" 
					DataSourceID="SelectedTimeSliceDataSource"
					EnableEmbeddedBaseStylesheet="false" EnableEmbeddedSkins="false" Skin="Voxco" ClientSettings-EnableRowHoverStyle="true">
						<ClientSettings>
							<Selecting AllowRowSelect="True" />
							<Scrolling AllowScroll="true" UseStaticHeaders="true" />
						</ClientSettings>
						<MasterTableView DataSourceID="SelectedTimeSliceDataSource" NoMasterRecordsText="" CommandItemDisplay="Top" ShowHeadersWhenNoRecords="true" Width="100%">
						<CommandItemTemplate>
							<asp:LinkButton ID="InsertTimeButton" CommandName="Insert" CausesValidation="false"
								Visible="true" ToolTip="<%$ Resources:Resource, Add %>" runat="server" OnClick="InsertTimeButton_Click">
								<img style="border: 0px;" alt="" src="../icons/element_new.png" />
								<asp:Label ID="Label9" runat="server" Text="<%$ Resources:Resource, Add %>"></asp:Label>
							</asp:LinkButton>
							<asp:LinkButton ID="DeleteTimeButton" CommandName="Delete" CausesValidation="false"
								Visible="true" ToolTip="<%$ Resources:Resource, Delete %>" runat="server" OnClick="DeleteTimeButton_Click">
								<img style="border: 0px;" alt="" src="../icons/trash.gif" />
								<asp:Label ID="Label5" runat="server" Text="<%$ Resources:Resource, Delete %>"></asp:Label>
							</asp:LinkButton>
							<asp:LinkButton ID="MoveUpTimeButton" CommandName="MoveUp" CausesValidation="false"
								Visible="true" ToolTip="<%$ Resources:Resource, MoveUp %>" runat="server" OnClick="MoveUpTimeButton_Click">
								<img style="border: 0px;" alt="" src="../icons/arrow_up_blue.png" />&nbsp;
								<asp:Label ID="Label11" runat="server" Text="<%$ Resources:Resource, MoveUp %>"></asp:Label>
							</asp:LinkButton>
							<asp:LinkButton ID="MoveDownTimeButton" CommandName="MoveDown" CausesValidation="false"
								Visible="true" ToolTip="<%$ Resources:Resource, MoveDown %>" runat="server" OnClick="MoveDownTimeButton_Click">
								<img style="border: 0px;" alt="" src="../icons/arrow_down_blue.png" />&nbsp;
								<asp:Label ID="Label12" runat="server" Text="<%$ Resources:Resource, MoveDown %>"></asp:Label>
							</asp:LinkButton>
						</CommandItemTemplate>
						<Columns>
							<telerik:GridClientSelectColumn DataType="System.Boolean" UniqueName="Selected">
								<HeaderStyle HorizontalAlign="Left" Width="10%" />
								<ItemStyle HorizontalAlign="Left" Width="10%" />
							</telerik:GridClientSelectColumn>
							<telerik:GridBoundColumn DataField="TimeSlice" DataType="System.String" HeaderText="<%$ Resources:Resource, SelectedTimeRanges%>" UniqueName="TimeSlice">
								<HeaderStyle Width="90%" HorizontalAlign="Left" />
								<ItemStyle Width="90%" HorizontalAlign="Left" />
							</telerik:GridBoundColumn>
						</Columns>
					</MasterTableView>
					</telerik:RadGrid>
				</div>				
			
			</div>
		</asp:Panel>
	</telerik:RadAjaxPanel>
</asp:Content>
